const router = require('express').Router();
const Response = require('../../models/Response.js');
const AdminService = require("../../services/adminServices/AdminService.js");
const Verify = require('../../services/VendorVerifyToken.js');
const adminService = new AdminService();

/**
 * @swagger
 * tags:
 *   name: AdminDetail
 *   description: API for managing authentication
 */

/**
 * @swagger
 * /api/admin:
 *    get:
 *     summary: Get all AdminDetails.
 *     tags: [AdminDetail]
 *     security:
 *       - apiKeyAuth: []  # Apply the apiKeyAuth security scheme to this endpoint
 *     responses:
 *       '200':
 *         description: Successful response
 *       '404':
 *         description: Subscription plan not found.
 *       '500':
 *         description: Internal server error.
 */

router.get('/',Verify, async function (req, res) {
    try {
        await adminService.getAdminDetail(req, res);
    }
    catch (e) {
        console.log(e);
    }
});

/**
 * @swagger
 * /api/admin/getAppVersion:
 *   get:
 *     summary: Get AdminDetails.
 *     description: Fetches admin details based on the type query parameter.
 *     tags: [AdminDetail]
 *     parameters:
 *       - in: query
 *         name: type
 *         schema:
 *           type: string
 *         required: false
 *         description: Filter by type ('vendor or customer'). If 'vendor', returns the App version.
 *     responses:
 *       200:
 *         description: Successful response, returns the admin details.
 *       404:
 *         description: No matching records found.
 *       500:
 *         description: Internal server error.
 */
router.get('/getAppVersion', async function (req, res) {
    try {
        await adminService.getAppVersion(req, res);
    }
    catch (e) {
        console.log(e);
    }
});


module.exports = router;