const router = require('express').Router();

const auth = require('./authControllers/authController');
const vendorcategory = require('./vendorControllers/vendorCategoryController');
const subscription = require('./vendorControllers/subscriptionController');
const vendorReviews = require('./vendorControllers/vendorReviewsController');
const leads = require('./vendorControllers/leadsController');
const notification = require('./vendorControllers/notificationController');
const vendor =require('./vendorControllers/vendorController');
const vendorPackage =require('./vendorControllers/vendorPackagesController');
const views =require('./vendorControllers/viewsController');
const location = require('./locationController');
// adminCotrollers
const admin = require('./adminControllers/adminController');
// userCotrollers
const users = require('./userController');
//customerCotrollers
const customerLeads = require('./customerControllers/customerLeadsController');
//auth api paths
router.use('/api/auth' , auth);
//user api paths
router.use('/api/customerapp', users);
//admin api paths
router.use('/api/admin', admin);
//vendor api paths
router.use('/api/vendorcategories', vendorcategory);
router.use('/api/vendors', vendor);
router.use('/api/location', location);
router.use('/api/subscription', subscription);
router.use('/api/vendorReviews', vendorReviews);
router.use('/api/leads', leads);
router.use('/api/notification', notification);
router.use('/api/packages', vendorPackage);
router.use('/api/views', views);
//customer api paths
router.use('/api/customerLeads', customerLeads);


module.exports  = router;