const { DataTypes } = require("sequelize");

module.exports = (sequelize, DataTypes) => {
    const Auth = sequelize.define("auth", {
        password: {
            type: DataTypes.STRING
        },
        user_name: {
            type: DataTypes.STRING,
            unique: true
        },
        phone: {
            type: DataTypes.STRING,
            // Remove unique constraint from here
        },
        code: {
            type: DataTypes.BIGINT,
        },
        is_account_verified: {
            type: DataTypes.BOOLEAN,
            defaultValue: false
        },
        user_type: {
            type: DataTypes.ENUM("vendor", "customer")
        }
    }, {
        tableName: "auth",
        indexes: [
            {
                unique: true,
                fields: ['user_type', 'phone']
            }
        ]
    });
    return Auth;
};
