const SequelizeSlugify = require("sequelize-slugify");
module.exports = (sequelize, DataTypes) => {
  const vendorCategories = sequelize.define(
    "vendorCategories",
    {
      name: {
        type: DataTypes.STRING,
      },

      parent_id: {
        type: DataTypes.INTEGER,
      },
      slug: {
        type: DataTypes.STRING,
        unique: true,
      },
      icon: {
        type: DataTypes.STRING,
      },
      images: {
        type: DataTypes.STRING,
      },
      color_code: {
        type: DataTypes.STRING,
      },
    },
    {
      tableName: "vendor_categories",
    }
  );

  SequelizeSlugify.slugifyModel(vendorCategories, {
    source: ["name"],
  });

  return vendorCategories;
};
