/// <reference types="node" />
import { inspect, InspectOptions } from "util";
import V1 from "../V1";
/**
 * Options to pass to create a PortingPortInInstance
 */
export interface PortingPortInListInstanceCreateOptions {
    /**  */
    body?: object;
}
export interface PortingPortInContext {
    /**
     * Remove a PortingPortInInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export interface PortingPortInContextSolution {
    portInRequestSid: string;
}
export declare class PortingPortInContextImpl implements PortingPortInContext {
    protected _version: V1;
    protected _solution: PortingPortInContextSolution;
    protected _uri: string;
    constructor(_version: V1, portInRequestSid: string);
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): PortingPortInContextSolution;
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
interface PortingPortInResource {
    port_in_request_sid: string;
    url: string;
}
export declare class PortingPortInInstance {
    protected _version: V1;
    protected _solution: PortingPortInContextSolution;
    protected _context?: PortingPortInContext;
    constructor(_version: V1, payload: PortingPortInResource, portInRequestSid?: string);
    /**
     * The SID of the Port In request. This is a unique identifier of the port in request.
     */
    portInRequestSid: string;
    url: string;
    private get _proxy();
    /**
     * Remove a PortingPortInInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        portInRequestSid: string;
        url: string;
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export interface PortingPortInSolution {
}
export interface PortingPortInListInstance {
    _version: V1;
    _solution: PortingPortInSolution;
    _uri: string;
    (portInRequestSid: string): PortingPortInContext;
    get(portInRequestSid: string): PortingPortInContext;
    /**
     * Create a PortingPortInInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed PortingPortInInstance
     */
    create(callback?: (error: Error | null, item?: PortingPortInInstance) => any): Promise<PortingPortInInstance>;
    /**
     * Create a PortingPortInInstance
     *
     * @param params - Body for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed PortingPortInInstance
     */
    create(params: object, callback?: (error: Error | null, item?: PortingPortInInstance) => any): Promise<PortingPortInInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function PortingPortInListInstance(version: V1): PortingPortInListInstance;
export {};
