/// <reference types="node" />
import { inspect, InspectOptions } from "util";
import V1 from "../V1";
export interface PortingPortInPhoneNumberContext {
    /**
     * Remove a PortingPortInPhoneNumberInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export interface PortingPortInPhoneNumberContextSolution {
    portInRequestSid: string;
    phoneNumberSid: string;
}
export declare class PortingPortInPhoneNumberContextImpl implements PortingPortInPhoneNumberContext {
    protected _version: V1;
    protected _solution: PortingPortInPhoneNumberContextSolution;
    protected _uri: string;
    constructor(_version: V1, portInRequestSid: string, phoneNumberSid: string);
    remove(callback?: (error: Error | null, item?: boolean) => any): Promise<boolean>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): PortingPortInPhoneNumberContextSolution;
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export interface PortingPortInPhoneNumberSolution {
}
export interface PortingPortInPhoneNumberListInstance {
    _version: V1;
    _solution: PortingPortInPhoneNumberSolution;
    _uri: string;
    (portInRequestSid: string, phoneNumberSid: string): PortingPortInPhoneNumberContext;
    get(portInRequestSid: string, phoneNumberSid: string): PortingPortInPhoneNumberContext;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function PortingPortInPhoneNumberListInstance(version: V1): PortingPortInPhoneNumberListInstance;
