/// <reference types="node" />
import { inspect, InspectOptions } from "util";
import V1 from "../V1";
export declare class CreateMessagesRequest {
    "messages"?: Array<MessagingV1Message>;
    /**
     * A Twilio phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format, an [alphanumeric sender ID](https://www.twilio.com/docs/sms/send-messages#use-an-alphanumeric-sender-id), or a [Channel Endpoint address](https://www.twilio.com/docs/sms/channels#channel-addresses) that is enabled for the type of message you want to send. Phone numbers or [short codes](https://www.twilio.com/docs/sms/api/short-code) purchased from Twilio also work here. You cannot, for example, spoof messages from a private cell phone number. If you are using `messaging_service_sid`, this parameter must be empty.
     */
    "from"?: string;
    /**
     * The SID of the [Messaging Service](https://www.twilio.com/docs/sms/services#send-a-message-with-copilot) you want to associate with the Message. Set this parameter to use the [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) you have configured and leave the `from` parameter empty. When only this parameter is set, Twilio will use your enabled Copilot Features to select the `from` phone number for delivery.
     */
    "messagingServiceSid"?: string;
    /**
     * The text of the message you want to send. Can be up to 1,600 characters in length.
     */
    "body"?: string;
    /**
     * The SID of the preconfigured [Content Template](https://www.twilio.com/docs/content-api/create-and-send-your-first-content-api-template#create-a-template) you want to associate with the Message. Must be used in conjuction with a preconfigured [Messaging Service Settings and Copilot Features](https://www.twilio.com/console/sms/services) When this parameter is set, Twilio will use your configured content template and the provided `ContentVariables`. This Twilio product is currently in Private Beta.
     */
    "contentSid"?: string;
    /**
     * The URL of the media to send with the message. The media can be of type `gif`, `png`, and `jpeg` and will be formatted correctly on the recipient\'s device. The media size limit is 5MB for supported file types (JPEG, PNG, GIF) and 500KB for [other types](https://www.twilio.com/docs/sms/accepted-mime-types) of accepted media. To send more than one image in the message body, provide multiple `media_url` parameters in the POST request. You can include up to 10 `media_url` parameters per message. You can send images in an SMS message in only the US and Canada.
     */
    "mediaUrl"?: Array<string>;
    /**
     * The URL we should call using the \"status_callback_method\" to send status information to your application. If specified, we POST these message status changes to the URL - queued, failed, sent, delivered, or undelivered. Twilio will POST its [standard request parameters](https://www.twilio.com/docs/messaging/twiml#request-parameters) as well as some additional parameters including \"MessageSid\", \"MessageStatus\", and \"ErrorCode\". If you include this parameter with the \"messaging_service_sid\", we use this URL instead of the Status Callback URL of the [Messaging Service](https://www.twilio.com/docs/messaging/services/api). URLs must contain a valid hostname and underscores are not allowed.
     */
    "statusCallback"?: string;
    /**
     * How long in seconds the message can remain in our outgoing message queue. After this period elapses, the message fails and we call your status callback. Can be between 1 and the default value of 14,400 seconds. After a message has been accepted by a carrier, however, we cannot guarantee that the message will not be queued after this period. We recommend that this value be at least 5 seconds.
     */
    "validityPeriod"?: number;
    /**
     * The time at which Twilio will send the message. This parameter can be used to schedule a message to be sent at a particular time. Must be in ISO 8601 format.
     */
    "sendAt"?: string;
    /**
     * This parameter indicates your intent to schedule a message. Pass the value `fixed` to schedule a message at a fixed time. This parameter works in conjuction with the `SendAt` parameter.
     */
    "scheduleType"?: string;
    /**
     * Determines the usage of Click Tracking. Setting it to `true` will instruct Twilio to replace all links in the Message with a shortened version based on the associated Domain Sid and track clicks on them. If this parameter is not set on an API call, we will use the value set on the Messaging Service. If this parameter is not set and the value is not configured on the Messaging Service used this will default to `false`.
     */
    "shortenUrls"?: boolean;
    /**
     * If set to True, Twilio will deliver the message as a single MMS message, regardless of the presence of media.
     */
    "sendAsMms"?: boolean;
    /**
     * The maximum total price in US dollars that you will pay for the message to be delivered. Can be a decimal value that has up to 4 decimal places. All messages are queued for delivery and the message cost is checked before the message is sent. If the cost exceeds max_price, the message will fail and a status of Failed is sent to the status callback. If MaxPrice is not set, the message cost is not checked.
     */
    "maxPrice"?: number;
    /**
     * Total number of attempts made ( including this ) to send out the message regardless of the provider used
     */
    "attempt"?: number;
    /**
     * This parameter indicates whether to detect Unicode characters that have a similar GSM-7 character and replace them. Can be true or false.
     */
    "smartEncoded"?: boolean;
    /**
     * This parameter allows Twilio to send SMS traffic to carriers without checking/caring whether the destination number is a mobile or a landline.
     */
    "forceDelivery"?: boolean;
    /**
     * The SID of the application that should receive message status. We POST a message_sid parameter and a message_status parameter with a value of sent or failed to the application\'s message_status_callback. If a status_callback parameter is also passed, it will be ignored and the application\'s message_status_callback parameter will be used.
     */
    "applicationSid"?: string;
}
export declare class MessagingV1FailedMessageReceipt {
    /**
     * The recipient phone number
     */
    "to"?: string;
    /**
     * The description of the error_code
     */
    "errorMessage"?: string;
    /**
     * The error code associated with the message creation attempt
     */
    "errorCode"?: number;
}
export declare class MessagingV1Message {
    /**
     * The destination phone number in [E.164](https://www.twilio.com/docs/glossary/what-e164) format for SMS/MMS or [Channel user address](https://www.twilio.com/docs/sms/channels#channel-addresses) for other 3rd-party channels.
     */
    "to"?: string;
    /**
     * The text of the message you want to send. Can be up to 1,600 characters in length. Overrides the request-level body and content template if provided.
     */
    "body"?: string;
    /**
     * Key-value pairs of variable names to substitution values. Refer to the [Twilio Content API Resources](https://www.twilio.com/docs/content-api/content-api-resources#send-a-message-with-preconfigured-content) for more details.
     */
    "contentVariables"?: {
        [key: string]: string;
    };
}
export declare class MessagingV1MessageReceipt {
    /**
     * The recipient phone number
     */
    "to"?: string | null;
    /**
     * The unique string that identifies the resource
     */
    "sid"?: string | null;
}
/**
 * Options to pass to create a MessageInstance
 */
export interface MessageListInstanceCreateOptions {
    /**  */
    createMessagesRequest: CreateMessagesRequest;
}
export interface MessageSolution {
}
export interface MessageListInstance {
    _version: V1;
    _solution: MessageSolution;
    _uri: string;
    /**
     * Create a MessageInstance
     *
     * @param params - Body for request
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed MessageInstance
     */
    create(params: CreateMessagesRequest, callback?: (error: Error | null, item?: MessageInstance) => any): Promise<MessageInstance>;
    /**
     * Provide a user-friendly representation
     */
    toJSON(): any;
    [inspect.custom](_depth: any, options: InspectOptions): any;
}
export declare function MessageListInstance(version: V1): MessageListInstance;
interface MessageResource {
    total_message_count: number;
    success_count: number;
    error_count: number;
    message_receipts: Array<MessagingV1MessageReceipt>;
    failed_message_receipts: Array<MessagingV1FailedMessageReceipt>;
}
export declare class MessageInstance {
    protected _version: V1;
    constructor(_version: V1, payload: MessageResource);
    /**
     * The number of Messages processed in the request, equal to the sum of success_count and error_count.
     */
    totalMessageCount: number;
    /**
     * The number of Messages successfully created.
     */
    successCount: number;
    /**
     * The number of Messages unsuccessfully processed in the request.
     */
    errorCount: number;
    messageReceipts: Array<MessagingV1MessageReceipt>;
    failedMessageReceipts: Array<MessagingV1FailedMessageReceipt>;
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON(): {
        totalMessageCount: number;
        successCount: number;
        errorCount: number;
        messageReceipts: MessagingV1MessageReceipt[];
        failedMessageReceipts: MessagingV1FailedMessageReceipt[];
    };
    [inspect.custom](_depth: any, options: InspectOptions): string;
}
export {};
