
const { Op } = require("sequelize");
const { adminDetail } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class AdminDetail {
async getAdminDetail(req, res) {
    try {
        const result= await adminDetail.findAll({
        attributes: ['id','item','value'],
        });
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS,result);
      }
     catch (error) {
      console.error('Error fetching Notification:', error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching notification');
    }
  }

  async getAppVersion(req, res) {
    try {
      const { type } = req.query;

      if (!type) {
        return res.status(400).json({ message: "Type query parameter is required" });
      }
      let whereClause = {};

      if (type === 'vendor') {
          whereClause = { item: 'VendorAppversion' };
      }
      if (type === 'customer') {
        whereClause = { item: 'CustomerAppversion' };
      }
      const result = await adminDetail.findAll({
          where: whereClause,
          attributes: ['id', 'item', 'value'],
      });

      if (!result.length) {
          return res.status(404).json({ message: "No matching records found" });
      }

    return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
  } catch (error) {
    console.error('Error fetching Admin Details:', error);
    return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching admin details');
  }
} 
}
module.exports = AdminDetail;
