const { Op } = require("sequelize");
const { leads,users } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class CustomerLeadsService {
  async addLeads(req, res){
    try {

      const { user_id, vendor_id, leads_contact_type, phone, name, email, details: additionalDetails, lead_date } = req.body;
        // Validate required fields
        if (!user_id || !vendor_id || !leads_contact_type) {
          return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, '');
        }

        let details = '';
        if (name) details += `${name},`;
        if (email) details += `${email},`;
        if (additionalDetails) details += additionalDetails;

        const formattedLeadDate = lead_date ? new Date(lead_date).toISOString().split('T')[0] : new Date().toISOString().split('T')[0];


        const result = await leads.create({
            user_id,
            vendor_id,
            leads_contact_type,
            phone,
            details,
            lead_date:formattedLeadDate
        });
       return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS,result);
    } catch (error) {
        console.error('Error creating new lead:', error);
        return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching subscription plans');
    }

  } 
}
module.exports = CustomerLeadsService;
