const { Op } = require("sequelize");
const { leads,users } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class LeadsService {

  async getLeadsByVendorId(req, res) {
    try {
        const vendorId = req.params.id; 
        if (!vendorId) {
            return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, '');
          }
        const response = await leads.findAll({
            where: {
                vendor_id: vendorId
            },
            include: [{
                model: users,
                attributes: ['name'] // Include only the 'name' attribute from the user table
            }]
        });
          
        
        const result = response.map(lead => ({
          name: lead.user.name,
          phone: lead.phone,
          type: lead.leads_contact_type,
          date: lead.lead_date
      }));
        
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS,result);
      }
     catch (error) {
      console.error('Error fetching leads:', error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching subscription plans');
    }
  }
}
module.exports = LeadsService;
