
const { Op } = require("sequelize");
const { notification } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class NotificationService {
async getNotificationVendorId(req, res) {
    try {
        const vendorId = req.params.id; 
        if (!vendorId) {
            return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, '');
          }
        const result= await notification.findAll({
            attributes: ['id','notification','type','is_read','vendor_id','createdAt'],
            where: {
                vendor_id: vendorId
            },
        });
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS,result);
      }
     catch (error) {
      console.error('Error fetching Notification:', error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching notification');
    }
  }
}
module.exports = NotificationService;
