const { Op } = require("sequelize");
const { subscriptionPlan, vendorSubscription } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class SubscriptionService {

  async getAllsubscriptionPlan(req, res) {
    try {
      const { subType } = req.query;
      let  condition
      // Check if id is provided, if so, fetch subscription plan by ID
      if (subType) {
        condition = {
          subscription_type:subType
        };    
      }          
      // If no id provided, fetch all subscription plans
      const result = await subscriptionPlan.findAll({where:condition});
      if(result.length == 0)
      {
        return genResponse(res, HTTP_STATUS_CODES.NOT_FOUND, RESPONSE_MSG.NORECORD, result);
      }
      // Splitting the comma-separated values into arrays for each plan in the result
      result.forEach(plan => {
        plan.month_1 = plan.month_1.split(',');
        plan.month_3 = plan.month_3.split(',');
        plan.month_6 = plan.month_6.split(',');
        plan.month_12 = plan.month_12.split(',');
        // Convert month_1 into an object with old and new keys
        plan.month_1 = { old_price: plan.month_1[0], new_price: plan.month_1[1] };
        plan.month_3 = { old_price: plan.month_3[0], new_price: plan.month_3[1] };
        plan.month_6 = { old_price: plan.month_6[0], new_price: plan.month_6[1] };
        plan.month_12 = { old_price: plan.month_12[0], new_price: plan.month_12[1] };
        // Splitting the description into an array if it contains comma-separated values
        if (plan.description.includes(',')) {
          plan.description = plan.description.split(',');
        }
      });
    
      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
      
    } catch (error) {
      console.error('Error fetching subscription plans:', error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, 'Error fetching subscription plans');
    }
  }

  async SubscribePlan(req, res) {
    try {
      // Extract data from request body
      const { name, sub_plan_id, vendor_id, month ,price} = req.body;
      if (!( name && sub_plan_id && month && vendor_id && price)) {
        return genResponse(res, HTTP_STATUS_CODES.BAD_REQUEST, RESPONSE_MSG.RPM, '');
      }
  
      let result;
      // Check if the vendor subscription already exists
      let existingSubscription = await vendorSubscription.findOne({ where: { vendor_id:vendor_id,is_paid:0} });
      if (!existingSubscription) {
        let vendorSub = {
          plan: name,
          vendor_id:vendor_id,
          sub_plan_id: sub_plan_id,
          month: month,
          is_expired: false,
          is_paid: false
        };

        // If the vendor subscription doesn't exist, create a new one
        result = await vendorSubscription.create(vendorSub);
      } else {
       
        // If the vendor subscription exists, update it
        result = await existingSubscription.update({
          plan: name,
          price:price,
          sub_plan_id: sub_plan_id,
          vendor_id:vendor_id,
          month: month,
          is_expired: false
        }
      );
      }
  
      // Respond with the created or updated vendor subscription
      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
    } catch (error) {
      // Handle errors
      console.error(error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, error);
    }
  }
}

module.exports = SubscriptionService;
