

const { Op } = require("sequelize");
const { vendorCategories } = require("../../models/dbCon");
const { genResponse, isEmpty, genPagingResponse, getLimitForPagination } = require("../../commons/commons");
const { HTTP_STATUS_CODES, RESPONSE_MSG } = require("../../commons/constants");

class VendorCategoryService {

//  async getAllVendorCategories(req, res) {
//     try {
//       const result = await vendorCategories.findAll({
//         attributes: ['id','name', 'slug']
//       });
//       return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);
//     }
//     catch (e) {
//         return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, e);
//     }
//   }

async getAllVendorCategories(req, res) {
  try {
      const { parentId } = req.query;

      let categories;

      // If parentId is provided, fetch its children categories
      if (parentId) {
          categories = await vendorCategories.findAll({
              where: { parent_id: parentId }
          });
      } else {
          // If no parentId is provided, fetch both parent categories and their children
          categories = await vendorCategories.findAll({
              include: [{ model: vendorCategories, as: 'children' }],
              where: { parent_id: null }
          });
      }

      return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, categories);
  } catch (error) {
      console.error('Error fetching vendor categories:', error);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.SMW, error.message);
  }
}




  async addCategory(req, res)  {
    try {
      const { name } = req.body;
      if (!name) {
        return genResponse(res, HTTP_STATUS_CODES.ERROR, RESPONSE_MSG.RPM,'');
      }

      
      let categoryCheck = await vendorCategories.findAll({
        where: {
          name: name
        }
      });
      if (categoryCheck != '') {
        return genResponse(res, HTTP_STATUS_CODES.UE, "Category name already exists");
      }
      else {
        let data = {
          name: name
        }
      
        const result = await vendorCategories.create(data);
        return genResponse(res, HTTP_STATUS_CODES.OK, RESPONSE_MSG.SUCCESS, result);

      }
    }
    catch (e) {
      console.log(e);
      return genResponse(res, HTTP_STATUS_CODES.INTERNAL_SERVER, RESPONSE_MSG.ERROR_OCCURED);
    }
  }

}

module.exports = VendorCategoryService;