const swaggerJsdoc = require('swagger-jsdoc');
const path = require('path');

const options = {
  definition: {
    openapi: '3.0.0',
    info: {
      title: 'Shaadi Bazaar APIs',
      version: '1.0.0',
      description: 'Shaadi Bazaar APIs with Swagger documentation',
    },
    servers: [
      {
         url: 'https://staging-t9umb.ondigitalocean.app'
        // url: 'http://localhost:9090/',
      },
    ],
    components: {
      securitySchemes: {
        apiKeyAuth: {
          type: 'apiKey',
          in: 'header',
          name: 'Authorization',
          description: 'API key needed to access the endpoints',
        },
      },
    },
  },
  apis: ['controller/**/*Controller.js'], // Recursive pattern for all .js files in controller
};

const specs = swaggerJsdoc(options);

module.exports = specs;
